//----------------------------------------------------------
// Copyright (C) Microsoft Corporation. All rights reserved.
//----------------------------------------------------------
var __extends=this.__extends||function(b,c){function a(){this.constructor=b}a.prototype=c.prototype;b.prototype=new a};define(["require","exports","Presentation/Scripts/TFS/TFS","Diagnostics/Scripts/TFS.Diag","Presentation/Scripts/TFS/TFS.Core","Presentation/Scripts/TFS/TFS.UI"],function(p,d,o,m,l,k){var e=o,a=m,c=l,j=k,n=j.domElem,f=c.delegate,i=function(){function d(b,c){a.assertParamIsNotNull(b,"nodes");this._nodes=b;this._options=$.extend({allowEmpty:false,sort:null},c);this._isTree=b.length>0&&typeof b[0]==="object";this._events=new Sys.EventHandlerList;this._isTree&&this._sortChildren({children:this._nodes},true);this._populateNodeMappings()}d.TREE_PATH_SEPERATER_CHAR="\\";d.EVENT_NEW_ITEM="new-item-event";d.EVENT_REMOVED_ITEM="removed-item-event";d.EVENT_UPDATE_ITEM="updated-item-event";d.prototype.reparentNode=function(b,c){a.assertParamIsObject(b,"node");a.assertParamIsObject(c,"newParent");this.removeNode(b.id);this.addNode(b,c)};d.prototype.isValidValue=function(b){a.assertParamIsString(b,"value");if(b===""&&this._options.allowEmpty)return true;if(this._nodes.length===0)return b!=="";b=this._cleanupPath(b);return this._pathToNodeMap.hasOwnProperty(b)};d.prototype.isTree=function(){return this._isTree};d.prototype.getNodes=function(){return this._nodes};d.prototype.getNode=function(b){a.assertParamIsString(b,"nodeText");b=this._cleanupPath(b);return this._pathToNodeMap[b]||null};d.prototype.getNodeFromId=function(b){a.assertParamIsString(b,"nodeId");return this._idToNodeMap[b]||null};d.prototype.updateNode=function(c){a.assertParamIsObject(c,"node");var b=this.getNodeFromId(c.id);if(typeof b==="undefined"){a.fail("Expected to find the node in the tree when updating a node. ID: "+c.id);return null}if(b.parentId!==c.parentId){a.fail("Expected the parentId of the node to be the same. If you're re-parenting, remove the node, then re-add it. ID: "+c.id);return null}if(b.text!==c.text){this._clearCache(b);b.text=c.text;this._addNode(b.parent,b)}b.values=c.values.slice(0);b.parent&&this._sortChildren(b.parent);this._raiseUpdateItem({node:b});return b};d.prototype.getRootNode=function(){var a=this.getNodes(),b=null;if(a&&a.length>0)b=a[0];return b};d.prototype.getPreviousSiblingNode=function(f){a.assertParamIsString(f,"id");var b,g,e=null,d=this.getNodeFromId(f),c;if(d){c=d.parent?d.parent.children:this._nodes;for(b=0,g=c.length;b<g;b+=1){if(c[b]===d)break;e=c[b]}}return e};d.prototype.removeNode=function(e){a.assertParamIsString(e,"id");var b=this.getNodeFromId(e),d;if(b){d=this._getChildrenCount(b)+1;if(b.parent&&b.parent.children)b.parent.children=c.ArrayUtils.subtract(b.parent.children,[b]);this._clearCache(b);this._raiseRemovedItem({node:b,parent:b.parent,treeSize:d})}return b};d.prototype.addNode=function(b,d){a.assertParamIsObject(b,"node");a.assertParamIsObject(d,"parent");var e=d.children;if(this.getNodeFromId(b.id)){a.fail("Shouldn't be adding a node to the tree that already exists. Id: "+b.id);return null}if(!this.getNodeFromId(d.id)){a.fail(c.StringUtils.format("Couldn't find parent node in the tree when adding a child node. Parent Id: {0}; Child Id: {1}.",d.id,b.id));return null}e.push(b);b.parentId=d.id;this._sortChildren(d,false);this._sortChildren(b,true);this._addNode(d,b);this._raiseNewItem({node:b,parent:d});return b};d.prototype.cloneSource=function(){return[b.cloneNode(this.getRootNode())]};d.prototype.attachNewItem=function(b){a.assertParamIsFunction(b,"handler");this._events.addHandler(d.EVENT_NEW_ITEM,b)};d.prototype.detachNewItem=function(b){a.assertParamIsFunction(b,"handler");this._events.removeHandler(d.EVENT_NEW_ITEM,b)};d.prototype.attachRemovedItem=function(b){a.assertParamIsFunction(b,"handler");this._events.addHandler(d.EVENT_REMOVED_ITEM,b)};d.prototype.detachRemovedItem=function(b){a.assertParamIsFunction(b,"handler");this._events.removeHandler(d.EVENT_REMOVED_ITEM,b)};d.prototype.attachUpdateItem=function(b){a.assertParamIsFunction(b,"handler");this._events.addHandler(d.EVENT_UPDATE_ITEM,b)};d.prototype.detachUpdateItem=function(b){a.assertParamIsFunction(b,"handler");this._events.removeHandler(d.EVENT_UPDATE_ITEM,b)};d.prototype._populateNodeMappings=function(){var a,c,b=this._nodes;this._pathToNodeMap={};this._idToNodeMap={};if(this._isTree)for(a=0,c=b.length;a<c;a+=1)this._addNode(null,b[a]);else for(a=0,c=b.length;a<c;a+=1)this._pathToNodeMap[b[a]]=b[a]};d.prototype._sortChildren=function(e,f,b){a.assertParamIsObject(e,"node");var d=e.children||[],c=d.length;b=b||this._options.sort;if($.isFunction(b)){d.sort(b);if(f)while(c>0){c-=1;this._sortChildren(d[c],true,b)}}};d.prototype._addNode=function(e,b){var f,h,g=(e===null?"":e.path+d.TREE_PATH_SEPERATER_CHAR)+b.text;b.path=g;e&&a.assert(e.id===b.parentId,c.StringUtils.format("Expected the parent's id ({0}) to match the node's parentId ({1})",e.id,b.parentId));b.parent=e;this._pathToNodeMap[g]=b;this._idToNodeMap[b.id]=b;if(b.children)for(f=0,h=b.children.length;f<h;f+=1)this._addNode(b,b.children[f])};d.prototype._clearCache=function(a){var b,c;if(a){delete this._pathToNodeMap[a.path];delete this._idToNodeMap[a.id];if(a.children)for(b=0,c=a.children.length;b<c;b+=1)this._clearCache(a.children[b])}};d.prototype._cleanupPath=function(c){a.assertParamIsString(c,"path");var b=c;if(b.length>0&&this.isTree()&&b.charAt(b.length-1)===d.TREE_PATH_SEPERATER_CHAR)b=b.substr(0,b.length-1);return b};d.prototype._getChildrenCount=function(c){a.assertParamIsObject(c,"node");var d,e,b=0;if($.isArray(c.children)){b=c.children.length;for(d=0,e=b;d<e;d+=1)b+=this._getChildrenCount(c.children[d])}return b};d.prototype._raiseNewItem=function(c){a.assertParamIsObject(c,"args");var b=this._events.getHandler(d.EVENT_NEW_ITEM);b&&b(this,c)};d.prototype._raiseRemovedItem=function(c){a.assertParamIsObject(c,"args");var b=this._events.getHandler(d.EVENT_REMOVED_ITEM);b&&b(this,c)};d.prototype._raiseUpdateItem=function(c){a.assertParamIsObject(c,"args");var b=this._events.getHandler(d.EVENT_UPDATE_ITEM);b&&b(this,c)};return d}();d.FieldDataProvider=i;e.initClassPrototype(i,{_events:null,_nodes:null,_idToNodeMap:null,_pathToNodeMap:null,_isTree:false,_options:null});var b=function(){function b(b,c,d){a.assertParamIsObject(b,"fieldDataProvider");a.assertParamIsObject(c,"grid");this._grid=c;this._options=$.extend({},d);this.dataProvider=b;this.dataProvider.attachNewItem(f(this,function(b,a){this._addNewItem(a.node,a.parent)}));this.dataProvider.attachRemovedItem(f(this,function(b,a){this._removeItem(a.node,a.parent,a.treeSize)}));this.dataProvider.attachUpdateItem(f(this,function(b,a){this._updateItem(a.node)}))}b._ITEM_ID_DATA_SOURCE_INDEX=-1;b.bindAdapter=function(h,e,d,i){a.assertParamIsObject(e,"fieldDataProvider");a.assertParamIsObject(d,"grid");var b,g,c,f=new h(e,d,i);c=d._options.columns;for(b=0,g=c.length;b<g;b++)delete c[b].index;f.refresh();return f};b.cloneNode=function(d){var c=$.extend({},d),a,e;c.children=[];delete c.parent;for(a=0,e=d.children.length;a<e;a+=1)c.children[a]=b.cloneNode(d.children[a]);return c};b.prototype.getGrid=function(){return this._grid};b.prototype.refresh=function(d){var e=this.dataProvider.getNodes(),a=[],c=this._grid.getExpandStates(),b=[];if(c)a=c.slice(0);this._flattenedItems=[];this._createDataSource(e,this._flattenedItems,b,1);if(!d){this._expandStates=b;if(this._expandStates&&this._expandStates.length===a.length)this._expandStates=a;this._grid.setDataSource(this._flattenedItems,this._expandStates,this._grid._options.columns)}};b.prototype.getNodeForDataIndex=function(c){a.assertParamIsNumber(c,"dataIndex");var d=this._flattenedItems[c];return d?this.dataProvider.getNodeFromId(d[b._ITEM_ID_DATA_SOURCE_INDEX]):null};b.prototype.getParentNodeIndexForDataIndex=function(b){if(!b)return-1;a.assertParamIsNumber(b,"dataIndex");var d=this.getNodeForDataIndex(b),c=-1;if(d)c=this.getDataIndexFromNode(d.parent);return c};b.prototype.getDataIndexFromNode=function(b){a.assertParamIsObject(b,"node");return b.dataIndex};b.prototype.cloneSource=function(){return[b.cloneNode(this.fieldDataHelper.getNodes()[0])]};b.prototype._createDataSource=function(c,b,a,d){this._populateDataSource(c,b,a,d)};b.prototype._constructRow=function(c){var a=[].concat(c.values);a[b._ITEM_ID_DATA_SOURCE_INDEX]=c.id;return a};b.prototype._populateDataSource=function(c,e,d,h){var b,f=c.length,a,g;for(a=0,g=c.length;a<g;a+=1){b=e.length;c[a].dataIndex=b;e[b]=this._constructRow(c[a]);d[b]=0;if(typeof c[a].children!=="undefined"){d[b]=this._populateDataSource(c[a].children,e,d,h+1);f+=d[b]}}return f};b.prototype._addNewItem=function(d,c){this.refresh(true);var a=this.getDataIndexFromNode(d),b=this.getDataIndexFromNode(c);if(a===0)this._expandStates.splice(this._expandStates.length,0,0);else this._expandStates.splice(a,0,0);this._updateExpandStates(b,1)};b.prototype._removeItem=function(d,c,b){a.assertParamIsObject(d,"node");a.assertParamIsObject(c,"parent");a.assertParamIsNumber(b,"treeSize");var f=this.getDataIndexFromNode(d),e=this.getDataIndexFromNode(c);this._expandStates.splice(f,b);this._updateExpandStates(e,-b);this.refresh(true)};b.prototype._updateItem=function(b){a.assertParamIsObject(b,"node");var d=this.getDataIndexFromNode(b),c;this.refresh(true);c=this.getDataIndexFromNode(b);this._moveExpandStatesForNode(d,c)};b.prototype._updateExpandStates=function(e,d){a.assertParamIsNumber(e,"itemIndex");a.assertParamIsNumber(d,"increment");var b=e,c=this._expandStates;if(b>=0)do{if(c[b]<0)c[b]-=d;else c[b]+=d;b=this.getParentNodeIndexForDataIndex(b)}while(b>=0)};b.prototype._moveExpandStatesForNode=function(c,e){var f=Math.abs(this._expandStates[c])+1,b,a,d;b=this._expandStates.splice(c,f);for(d=b.length,a=d-1;a>=0;a-=1)this._expandStates.splice(e,0,b[a])};return b}();d.HierarchicalGridDataAdapter=b;e.initClassPrototype(b,{_flattenedItems:null,_grid:null,_expandStates:[],_options:{},_expandStatesManager:null,dataProvider:null,fieldDataHelper:null});var h=function(e){__extends(d,e);function d(g,c,b){e.call(this,g,c);a.assertParamIsObject(g,"fieldDataProvider");a.assertParamIsObject(c,"grid");a.assertParamIsObject(b,"options");this._events=new Sys.EventHandlerList;this._checkboxRangeRootId=b.rootNodeId||null;this._noCheckboxes=b.noCheckboxes;this._allEnabled=b.allEnabled===undefined?true:b.allEnabled;var f=this,i=c._options.columns,h={canSortBy:false,text:"",width:30,fixed:true,name:d.CHECK_COLUMN_NAME,getCellContents:function(g,a,c,h,b){return f._createCheckboxCell(a,b)}};if(!b.noColumn){i.splice(d._CHECKBOX_COLUMN_INDEX,0,h);c.getElement().keyup(function(d){var b,c,a;if(d.keyCode===j.KeyCode.SPACE){b=f._grid.getSelectedDataIndex();a=f._findCheckbox(b);if(a.length===1&&!a.attr("disabled")){c=!a.attr("checked");a.attr("checked",c);f._setCheckedState(b,c)}}})}this._disabledTooltip=b.disabledTooltip||"";if(b.disableChildren&&$.isFunction(b.disableChildren))this._disableChildren=b.disableChildren;else this._disableChildren=function(){return true};this.initialize(b.checkedItemIds||[])}d._CHECKBOX_COLUMN_INDEX=0;d._LABEL_COLUMN_INDEX=1;d._CHECK_CHANGED="checked-items-changed";d.CHECK_COLUMN_NAME="checks-column";d.prototype.initialize=function(b){var c,a,d;c={};for(a=0,d=b.length;a<d;a+=1)c[b[a]]=b[a];this._checkedItems=c;this._blockedCheckIds={}};d.prototype.hasCheckBox=function(b){a.assertParamIsNumber(b,"dataIndex");return b>=this._checkboxRangeBegin&&b<=this._checkboxRangeEnd};d.prototype.updateCheckboxesRange=function(c){a.assertParamIsArray(c,"expandStates",false);var b,e,d;if(this._checkboxRangeRootId){b=this.dataProvider.getNodeFromId(this._checkboxRangeRootId);if(b){d=this.getDataIndexFromNode(b);e=Math.abs(c[d]);this._checkboxRangeBegin=b.dataIndex+1;this._checkboxRangeEnd=b.dataIndex+e}}else if(this._noCheckboxes){this._checkboxRangeBegin=-1;this._checkboxRangeEnd=-1}else{this._checkboxRangeBegin=0;this._checkboxRangeEnd=this._flattenedItems.length-1}};d.prototype.isLeafNode=function(b){a.assertParamIsObject(b,"node");return this._expandStates[b.dataIndex]===0};d.prototype.blockCheck=function(b){a.assertParamIsString(b,"id");this._blockedCheckIds[b]=true;this._grid.updateRow(undefined,this._getDataIndexFromId(b))};d.prototype.unblockCheck=function(b){a.assertParamIsString(b,"id");if(this._blockedCheckIds.hasOwnProperty(b)){delete this._blockedCheckIds[b];this._grid.updateRow(undefined,this._getDataIndexFromId(b))}};d.prototype.setCheckboxRangeRoot=function(b){a.assertParamIsString(b,"id");this._checkboxRangeRootId=b;this.refresh()};d.prototype.getCheckboxRangeRoot=function(){return this._checkboxRangeRootId};d.prototype.attachCheckedItemsChanged=function(b){a.assertParamIsFunction(b,"handler");this._events.addHandler(d._CHECK_CHANGED,b)};d.prototype.detachCheckedItemsChanged=function(b){a.assertParamIsFunction(b,"handler");this._events.removeHandler(d._CHECK_CHANGED,b)};d.prototype._createDataSource=function(n,m,f,o){var a,l,h=[],c,k,g=d._CHECKBOX_COLUMN_INDEX,i=b._ITEM_ID_DATA_SOURCE_INDEX,j;e.prototype._createDataSource.call(this,n,m,f,o);c=this._flattenedItems;this.updateCheckboxesRange(f);for(a=0,l=f.length;a<l;a++)if(this.hasCheckBox(a)){k=Math.abs(f[a]);h[a]=true;if(this._disableChildren(c[a][i])&&c[a][g]){j=a;while(a<j+k){h[++a]=false;c[a][g]=false;delete this._checkedItems[c[a][i]]}}}else{delete this._checkedItems[c[a][i]];c[a][g]=false}this._itemStates=h};d.prototype.setItemState=function(b,c){a.assertIsNotNull(b,"id");a.assertParamIsBool(c,"enabled");if(c)this._checkedItems[b]=b;else delete this._checkedItems[b]};d.prototype.getItemChecked=function(a){return this._grid.getColumnValue(a,d._CHECKBOX_COLUMN_INDEX)};d.prototype.setItemTitle=function(c,b){a.assertParamIsString(c,"id");a.assertParamIsString(b,"title");var e=this._getDataIndexFromId(c),d=this._findCheckbox(e);d.attr("title",b)};d.prototype.resetItemTitle=function(b){a.assertParamIsString(b,"id");var d=this._getDataIndexFromId(b),c=this._findCheckbox(d);this._setCheckboxDefaultTitle(c)};d.prototype.getCheckedItemIds=function(){var a,j,i=[],k=d._CHECKBOX_COLUMN_INDEX,h=b._ITEM_ID_DATA_SOURCE_INDEX,c,e=this._flattenedItems,g=this._itemStates,f;c={};for(a=0,j=g.length;a<j;a++)if(g[a]&&e[a][k])c[e[a][h]]=e[a][h];this._checkedItems=c;for(f in c)c.hasOwnProperty(f)&&i.push(c[f]);return i};d.prototype.setCheckboxStateData=function(c,g){a.assert(typeof c==="number","Expected to be a number");a.assert(typeof g==="boolean","Expected to be a number");var e,i=Math.abs(this._expandStates[c]),f=this._grid._dataSource,h=f[c][b._ITEM_ID_DATA_SOURCE_INDEX];f[c][d._CHECKBOX_COLUMN_INDEX]=g;if(this._disableChildren(h))for(e=c+1;e<=c+i;e++){f[e][d._CHECKBOX_COLUMN_INDEX]=false;this.setItemState(f[e][b._ITEM_ID_DATA_SOURCE_INDEX],false);this._itemStates[e]=!g;this._grid.updateRow(undefined,e)}this.setItemState(h,g);this._grid.updateRow(undefined,c)};d.prototype.getCheckboxState=function(b){a.assertParamIsNumber(b,"dataIndex");var c=this._grid._dataSource;return b>=0?c[b][d._CHECKBOX_COLUMN_INDEX]:false};d.prototype.getItemEnabled=function(a){return this._allEnabled&&this._itemStates[a]&&!this._blockedCheckIds[this._getIdFromDataIndex(a)]};d.prototype.getBranchCheckedState=function(){var b=true,g=this._grid._dataSource,e=this.dataProvider.getRootNode(),a=[],c,f;if(e)a=e.children;if(!a||a.length===0)b=false;else for(c=0,f=a.length;c<f&&b;c+=1)b=g[a[c].dataIndex][d._CHECKBOX_COLUMN_INDEX];return b};d.prototype._constructRow=function(b){a.assertParamIsObject(b,"sourceRow");var c=e.prototype._constructRow.call(this,b),f=this._checkedItems.hasOwnProperty(b.id);c.splice(d._CHECKBOX_COLUMN_INDEX,0,f);return c};d.prototype._getCheckboxCellId=function(b){a.assertParamIsNumber(b,"dataIndex");var d=this._grid._getId()||"";return c.StringUtils.format("checkbox-{0}-{1}",d,b)};d.prototype._findCheckbox=function(d){a.assertParamIsNumber(d,"dataIndex");var c=this._getCheckboxCellId(d),b=$("#"+c);a.assert(b.length<=1,"Expected there to be at most one checkbox with the given ID: "+c+", instead saw: "+b.length);return b};d.prototype._createCheckboxCell=function(b,h){a.assertParamIsNumber(b,"dataIndex");a.assertParamIsObject(h,"column");a.assert(d._CHECKBOX_COLUMN_INDEX===h.index,c.StringUtils.format("Expected that the checkbox column is in position {0}. Actual index is {1}",d._CHECKBOX_COLUMN_INDEX,h.index));var e,i=this._getCheckboxCellId(b),g,l,k,j;e=$(n("div","grid-cell"));e.width(h.width||20);if(this.hasCheckBox(b)){k=this.getItemEnabled(b);j=this.getItemChecked(b);l=$("<label class='hidden' for='"+i+"'/>").text(this._grid.getColumnValue(b,d._LABEL_COLUMN_INDEX));e.append(l);g=$("<input type='checkbox' tabindex='-1' id='"+i+"'>").data("checkbox-data-index",b).attr("checked",j).attr("disabled",!k);this._setCheckboxDefaultTitle(g);g.click(f(this,this._onCheckboxClicked));e.append(g)}return e};d.prototype._onCheckboxClicked=function(e){a.logTracePoint("TFS.UI.Controls.Data.ChecklistDataAdapter._onCheckboxClicked.start");var b=$(e.currentTarget),c,d;c=b.data("checkbox-data-index");d=b.is(":checked");this._setCheckedState(c,d)};d.prototype._setCheckedState=function(a,b){this.setCheckboxStateData(a,b);this._raiseCheckedItemsChanged({id:this._getIdFromDataIndex(a)})};d.prototype._raiseCheckedItemsChanged=function(c){a.assertParamIsObject(c,"args");var b=this._events.getHandler(d._CHECK_CHANGED);b&&b(this,c)};d.prototype._setCheckboxDefaultTitle=function(b){a.assertParamIsJQueryObject(b,"$checkbox");a.assert(b.length<=1,"Expected at most one checkbox to be passed in. Got: "+b.length);b.attr("title",b.attr("disabled")?this._disabledTooltip:"")};d.prototype._getIdFromDataIndex=function(c){a.assertParamIsNumber(c,"dataIndex");return this._flattenedItems[c][b._ITEM_ID_DATA_SOURCE_INDEX]};d.prototype._getDataIndexFromId=function(c){a.assertParamIsString(c,"id");var b=this.dataProvider.getNodeFromId(c);a.assert(Boolean(b),"Expected to find a node for id: "+c);return b?b.dataIndex:undefined};return d}(b);d.ChecklistDataAdapter=h;e.initClassPrototype(h,{_checkedItems:null,_itemStates:null,_events:null,_disabledTooltip:null,_checkboxRangeRootId:null,_checkboxRangeBegin:null,_checkboxRangeEnd:null,_allEnabled:true,_blockedCheckIds:null,_disableChildren:null,_noCheckboxes:null});var g=function(){function b(b,c){a.assertParamIsObject(b,"grid");this._options=c;this._grid=b}b.prototype.getTableFromSelectedItems=function(){a.logTracePoint("TFS.UI.Controls.Data.TabDelimitedTableFormatter.getTableFromSelectedItems.start");var e=this._grid,f=e.getSelectedDataIndices(),b=new c.StringBuilder,d;d=e.getColumns();if(f.length===0||d.length===0)return"";$.each(d,function(d,a){d>0&&b.append(c.StringUtils.tab);b.append(a.text)});b.appendNewLine();$.each(f,function(a,f){a>0&&b.appendNewLine();b.append($.map(d,function(a){return e.getColumnText(f,a)}).join(c.StringUtils.tab))});a.logTracePoint("TFS.UI.Controls.Data.TabDelimitedTableFormatter.getTableFromSelectedItems.complete");return b.toString()};return b}();d.TabDelimitedTableFormatter=g;e.initClassPrototype(g,{_options:null,_grid:null});e.tfsModuleLoaded("TFS.UI.Controls.Data",d)});
// SIG // Begin signature block
// SIG // MIIbDwYJKoZIhvcNAQcCoIIbADCCGvwCAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFKXEgUNoRPwp
// SIG // XOEqjGCdgWQzT0aCoIIVgjCCBMMwggOroAMCAQICEzMA
// SIG // AABxsy6Ka4KqH04AAAAAAHEwDQYJKoZIhvcNAQEFBQAw
// SIG // dzELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjEhMB8GA1UEAxMYTWlj
// SIG // cm9zb2Z0IFRpbWUtU3RhbXAgUENBMB4XDTE1MDMyMDE3
// SIG // MzIwM1oXDTE2MDYyMDE3MzIwM1owgbMxCzAJBgNVBAYT
// SIG // AlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQH
// SIG // EwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29y
// SIG // cG9yYXRpb24xDTALBgNVBAsTBE1PUFIxJzAlBgNVBAsT
// SIG // Hm5DaXBoZXIgRFNFIEVTTjpCOEVDLTMwQTQtNzE0NDEl
// SIG // MCMGA1UEAxMcTWljcm9zb2Z0IFRpbWUtU3RhbXAgU2Vy
// SIG // dmljZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
// SIG // ggEBAOqRvbKI/RRvITYoA2YzOmYI+1tLpKugKDRKQzII
// SIG // wIblyT3VJbx7PmKH1n3vD3RTo/GRY4h0f+gkzQNQxfHK
// SIG // ABZ7pTmwBhw8RH7568SygbwXI7r9ZTgZhX/KoCn99jrA
// SIG // Cy9o9OA0Tn1vF8Bumar6f2El0SZw0nR932FzXM5UKjlR
// SIG // AzMJ+FCteMeJCLbUhSo/19gfUerv/GhetcHnB2gyjS9y
// SIG // Uf4DMUdRxdLrcgevIJX42mr4d2fkYJpwTKtFy34Ir+WB
// SIG // 1FfPOswTdZ0mzaCiaVC8OoiU37BUON6JOc2GMqWQD36/
// SIG // 7cyUJaZBhmEmx903flwN6BfKN3/oJLZOtPgbI+sCAwEA
// SIG // AaOCAQkwggEFMB0GA1UdDgQWBBT4/SOHBZSAVs0zpUHC
// SIG // bMwINsiyojAfBgNVHSMEGDAWgBQjNPjZUkZwCu1A+3b7
// SIG // syuwwzWzDzBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8v
// SIG // Y3JsLm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0
// SIG // cy9NaWNyb3NvZnRUaW1lU3RhbXBQQ0EuY3JsMFgGCCsG
// SIG // AQUFBwEBBEwwSjBIBggrBgEFBQcwAoY8aHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNyb3Nv
// SIG // ZnRUaW1lU3RhbXBQQ0EuY3J0MBMGA1UdJQQMMAoGCCsG
// SIG // AQUFBwMIMA0GCSqGSIb3DQEBBQUAA4IBAQAtBLTKKQtZ
// SIG // /C7qoK9MTmgE+JLtKcJmzGtwyYfovof8XfTdT6Uab3iX
// SIG // rWsFOFFBcp055Bobw21x/HC208y2kFgEKD/WHu+DsxQY
// SIG // DJUL96URE5jGhVZe7jO0DDe1gOr1EmjZLnuGCHI7FHvU
// SIG // 2dAWT8AvCx8tyuUb0K7phLCPC11zuBaBQCNYLOphqv69
// SIG // f9ONWnD8ec1mlmVjtQUSduIqOyvtgqya7CdBp5cOIxaf
// SIG // QchObVMRQATMYJnamOwrrpf74H31uosA9CUXf2J6u1FX
// SIG // wfDwzZwbYXOtlYwrdiKoq3A4tAEofWZCU96f9Ad8WjAO
// SIG // ggNZ9oSGuRUlYrAL0s/x25ZFMIIE7DCCA9SgAwIBAgIT
// SIG // MwAAAQosea7XeXumrAABAAABCjANBgkqhkiG9w0BAQUF
// SIG // ADB5MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGlu
// SIG // Z3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMV
// SIG // TWljcm9zb2Z0IENvcnBvcmF0aW9uMSMwIQYDVQQDExpN
// SIG // aWNyb3NvZnQgQ29kZSBTaWduaW5nIFBDQTAeFw0xNTA2
// SIG // MDQxNzQyNDVaFw0xNjA5MDQxNzQyNDVaMIGDMQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMQ0wCwYDVQQLEwRNT1BSMR4wHAYD
// SIG // VQQDExVNaWNyb3NvZnQgQ29ycG9yYXRpb24wggEiMA0G
// SIG // CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCS/G82u+ED
// SIG // uSjWRtGiYbqlRvtjFj4u+UfSx+ztx5mxJlF1vdrMDwYU
// SIG // EaRsGZ7AX01UieRNUNiNzaFhpXcTmhyn7Q1096dWeego
// SIG // 91PSsXpj4PWUl7fs2Uf4bD3zJYizvArFBKeOfIVIdhxh
// SIG // RqoZxHpii8HCNar7WG/FYwuTSTCBG3vff3xPtEdtX3gc
// SIG // r7b3lhNS77nRTTnlc95ITjwUqpcNOcyLUeFc0Tvwjmfq
// SIG // MGCpTVqdQ73bI7rAD9dLEJ2cTfBRooSq5JynPdaj7woY
// SIG // SKj6sU6lmA5Lv/AU8wDIsEjWW/4414kRLQW6QwJPIgCW
// SIG // Ja19NW6EaKsgGDgo/hyiELGlAgMBAAGjggFgMIIBXDAT
// SIG // BgNVHSUEDDAKBggrBgEFBQcDAzAdBgNVHQ4EFgQUif4K
// SIG // MeomzeZtx5GRuZSMohhhNzQwUQYDVR0RBEowSKRGMEQx
// SIG // DTALBgNVBAsTBE1PUFIxMzAxBgNVBAUTKjMxNTk1KzA0
// SIG // MDc5MzUwLTE2ZmEtNGM2MC1iNmJmLTlkMmIxY2QwNTk4
// SIG // NDAfBgNVHSMEGDAWgBTLEejK0rQWWAHJNy4zFha5TJoK
// SIG // HzBWBgNVHR8ETzBNMEugSaBHhkVodHRwOi8vY3JsLm1p
// SIG // Y3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9NaWND
// SIG // b2RTaWdQQ0FfMDgtMzEtMjAxMC5jcmwwWgYIKwYBBQUH
// SIG // AQEETjBMMEoGCCsGAQUFBzAChj5odHRwOi8vd3d3Lm1p
// SIG // Y3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY0NvZFNpZ1BD
// SIG // QV8wOC0zMS0yMDEwLmNydDANBgkqhkiG9w0BAQUFAAOC
// SIG // AQEApqhTkd87Af5hXQZa62bwDNj32YTTAFEOENGk0Rco
// SIG // 54wzOCvYQ8YDi3XrM5L0qeJn/QLbpR1OQ0VdG0nj4E8W
// SIG // 8H6P8IgRyoKtpPumqV/1l2DIe8S/fJtp7R+CwfHNjnhL
// SIG // YvXXDRzXUxLWllLvNb0ZjqBAk6EKpS0WnMJGdAjr2/TY
// SIG // pUk2VBIRVQOzexb7R/77aPzARVziPxJ5M6LvgsXeQBkH
// SIG // 7hXFCptZBUGp0JeegZ4DW/xK4xouBaxQRy+M+nnYHiD4
// SIG // BfspaxgU+nIEtwunmmTsEV1PRUmNKRot+9C2CVNfNJTg
// SIG // FsS56nM16Ffv4esWwxjHBrM7z2GE4rZEiZSjhjCCBbww
// SIG // ggOkoAMCAQICCmEzJhoAAAAAADEwDQYJKoZIhvcNAQEF
// SIG // BQAwXzETMBEGCgmSJomT8ixkARkWA2NvbTEZMBcGCgmS
// SIG // JomT8ixkARkWCW1pY3Jvc29mdDEtMCsGA1UEAxMkTWlj
// SIG // cm9zb2Z0IFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5
// SIG // MB4XDTEwMDgzMTIyMTkzMloXDTIwMDgzMTIyMjkzMlow
// SIG // eTELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjEjMCEGA1UEAxMaTWlj
// SIG // cm9zb2Z0IENvZGUgU2lnbmluZyBQQ0EwggEiMA0GCSqG
// SIG // SIb3DQEBAQUAA4IBDwAwggEKAoIBAQCycllcGTBkvx2a
// SIG // YCAgQpl2U2w+G9ZvzMvx6mv+lxYQ4N86dIMaty+gMuz/
// SIG // 3sJCTiPVcgDbNVcKicquIEn08GisTUuNpb15S3GbRwfa
// SIG // /SXfnXWIz6pzRH/XgdvzvfI2pMlcRdyvrT3gKGiXGqel
// SIG // cnNW8ReU5P01lHKg1nZfHndFg4U4FtBzWwW6Z1KNpbJp
// SIG // L9oZC/6SdCnidi9U3RQwWfjSjWL9y8lfRjFQuScT5EAw
// SIG // z3IpECgixzdOPaAyPZDNoTgGhVxOVoIoKgUyt0vXT2Pn
// SIG // 0i1i8UU956wIAPZGoZ7RW4wmU+h6qkryRs83PDietHdc
// SIG // pReejcsRj1Y8wawJXwPTAgMBAAGjggFeMIIBWjAPBgNV
// SIG // HRMBAf8EBTADAQH/MB0GA1UdDgQWBBTLEejK0rQWWAHJ
// SIG // Ny4zFha5TJoKHzALBgNVHQ8EBAMCAYYwEgYJKwYBBAGC
// SIG // NxUBBAUCAwEAATAjBgkrBgEEAYI3FQIEFgQU/dExTtMm
// SIG // ipXhmGA7qDFvpjy82C0wGQYJKwYBBAGCNxQCBAweCgBT
// SIG // AHUAYgBDAEEwHwYDVR0jBBgwFoAUDqyCYEBWJ5flJRP8
// SIG // KuEKU5VZ5KQwUAYDVR0fBEkwRzBFoEOgQYY/aHR0cDov
// SIG // L2NybC5taWNyb3NvZnQuY29tL3BraS9jcmwvcHJvZHVj
// SIG // dHMvbWljcm9zb2Z0cm9vdGNlcnQuY3JsMFQGCCsGAQUF
// SIG // BwEBBEgwRjBEBggrBgEFBQcwAoY4aHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNyb3NvZnRS
// SIG // b290Q2VydC5jcnQwDQYJKoZIhvcNAQEFBQADggIBAFk5
// SIG // Pn8mRq/rb0CxMrVq6w4vbqhJ9+tfde1MOy3XQ60L/svp
// SIG // LTGjI8x8UJiAIV2sPS9MuqKoVpzjcLu4tPh5tUly9z7q
// SIG // QX/K4QwXaculnCAt+gtQxFbNLeNK0rxw56gNogOlVuC4
// SIG // iktX8pVCnPHz7+7jhh80PLhWmvBTI4UqpIIck+KUBx3y
// SIG // 4k74jKHK6BOlkU7IG9KPcpUqcW2bGvgc8FPWZ8wi/1wd
// SIG // zaKMvSeyeWNWRKJRzfnpo1hW3ZsCRUQvX/TartSCMm78
// SIG // pJUT5Otp56miLL7IKxAOZY6Z2/Wi+hImCWU4lPF6H0q7
// SIG // 0eFW6NB4lhhcyTUWX92THUmOLb6tNEQc7hAVGgBd3TVb
// SIG // Ic6YxwnuhQ6MT20OE049fClInHLR82zKwexwo1eSV32U
// SIG // jaAbSANa98+jZwp0pTbtLS8XyOZyNxL0b7E8Z4L5UrKN
// SIG // MxZlHg6K3RDeZPRvzkbU0xfpecQEtNP7LN8fip6sCvsT
// SIG // J0Ct5PnhqX9GuwdgR2VgQE6wQuxO7bN2edgKNAltHIAx
// SIG // H+IOVN3lofvlRxCtZJj/UBYufL8FIXrilUEnacOTj5XJ
// SIG // jdibIa4NXJzwoq6GaIMMai27dmsAHZat8hZ79haDJLmI
// SIG // z2qoRzEvmtzjcT3XAH5iR9HOiMm4GPoOco3Boz2vAkBq
// SIG // /2mbluIQqBC0N1AI1sM9MIIGBzCCA++gAwIBAgIKYRZo
// SIG // NAAAAAAAHDANBgkqhkiG9w0BAQUFADBfMRMwEQYKCZIm
// SIG // iZPyLGQBGRYDY29tMRkwFwYKCZImiZPyLGQBGRYJbWlj
// SIG // cm9zb2Z0MS0wKwYDVQQDEyRNaWNyb3NvZnQgUm9vdCBD
// SIG // ZXJ0aWZpY2F0ZSBBdXRob3JpdHkwHhcNMDcwNDAzMTI1
// SIG // MzA5WhcNMjEwNDAzMTMwMzA5WjB3MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSEwHwYDVQQDExhNaWNyb3NvZnQgVGltZS1T
// SIG // dGFtcCBQQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQCfoWyx39tIkip8ay4Z4b3i48WZUSNQrc7d
// SIG // GE4kD+7Rp9FMrXQwIBHrB9VUlRVJlBtCkq6YXDAm2gBr
// SIG // 6Hu97IkHD/cOBJjwicwfyzMkh53y9GccLPx754gd6udO
// SIG // o6HBI1PKjfpFzwnQXq/QsEIEovmmbJNn1yjcRlOwhtDl
// SIG // KEYuJ6yGT1VSDOQDLPtqkJAwbofzWTCd+n7Wl7PoIZd+
// SIG // +NIT8wi3U21StEWQn0gASkdmEScpZqiX5NMGgUqi+YSn
// SIG // EUcUCYKfhO1VeP4Bmh1QCIUAEDBG7bfeI0a7xC1Un68e
// SIG // eEExd8yb3zuDk6FhArUdDbH895uyAc4iS1T/+QXDwiAL
// SIG // AgMBAAGjggGrMIIBpzAPBgNVHRMBAf8EBTADAQH/MB0G
// SIG // A1UdDgQWBBQjNPjZUkZwCu1A+3b7syuwwzWzDzALBgNV
// SIG // HQ8EBAMCAYYwEAYJKwYBBAGCNxUBBAMCAQAwgZgGA1Ud
// SIG // IwSBkDCBjYAUDqyCYEBWJ5flJRP8KuEKU5VZ5KShY6Rh
// SIG // MF8xEzARBgoJkiaJk/IsZAEZFgNjb20xGTAXBgoJkiaJ
// SIG // k/IsZAEZFgltaWNyb3NvZnQxLTArBgNVBAMTJE1pY3Jv
// SIG // c29mdCBSb290IENlcnRpZmljYXRlIEF1dGhvcml0eYIQ
// SIG // ea0WoUqgpa1Mc1j0BxMuZTBQBgNVHR8ESTBHMEWgQ6BB
// SIG // hj9odHRwOi8vY3JsLm1pY3Jvc29mdC5jb20vcGtpL2Ny
// SIG // bC9wcm9kdWN0cy9taWNyb3NvZnRyb290Y2VydC5jcmww
// SIG // VAYIKwYBBQUHAQEESDBGMEQGCCsGAQUFBzAChjhodHRw
// SIG // Oi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpL2NlcnRzL01p
// SIG // Y3Jvc29mdFJvb3RDZXJ0LmNydDATBgNVHSUEDDAKBggr
// SIG // BgEFBQcDCDANBgkqhkiG9w0BAQUFAAOCAgEAEJeKw1wD
// SIG // RDbd6bStd9vOeVFNAbEudHFbbQwTq86+e4+4LtQSooxt
// SIG // YrhXAstOIBNQmd16QOJXu69YmhzhHQGGrLt48ovQ7DsB
// SIG // 7uK+jwoFyI1I4vBTFd1Pq5Lk541q1YDB5pTyBi+FA+mR
// SIG // KiQicPv2/OR4mS4N9wficLwYTp2OawpylbihOZxnLcVR
// SIG // DupiXD8WmIsgP+IHGjL5zDFKdjE9K3ILyOpwPf+FChPf
// SIG // wgphjvDXuBfrTot/xTUrXqO/67x9C0J71FNyIe4wyrt4
// SIG // ZVxbARcKFA7S2hSY9Ty5ZlizLS/n+YWGzFFW6J1wlGys
// SIG // OUzU9nm/qhh6YinvopspNAZ3GmLJPR5tH4LwC8csu89D
// SIG // s+X57H2146SodDW4TsVxIxImdgs8UoxxWkZDFLyzs7BN
// SIG // Z8ifQv+AeSGAnhUwZuhCEl4ayJ4iIdBD6Svpu/RIzCzU
// SIG // 2DKATCYqSCRfWupW76bemZ3KOm+9gSd0BhHudiG/m4LB
// SIG // J1S2sWo9iaF2YbRuoROmv6pH8BJv/YoybLL+31HIjCPJ
// SIG // Zr2dHYcSZAI9La9Zj7jkIeW1sMpjtHhUBdRBLlCslLCl
// SIG // eKuzoJZ1GtmShxN1Ii8yqAhuoFuMJb+g74TKIdbrHk/J
// SIG // mu5J4PcBZW+JC33Iacjmbuqnl84xKf8OxVtc2E0bodj6
// SIG // L54/LlUWa8kTo/0xggT5MIIE9QIBATCBkDB5MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSMwIQYDVQQDExpNaWNyb3NvZnQg
// SIG // Q29kZSBTaWduaW5nIFBDQQITMwAAAQosea7XeXumrAAB
// SIG // AAABCjAJBgUrDgMCGgUAoIIBETAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAjBgkqhkiG9w0BCQQxFgQUEC2JwKSY
// SIG // rQQLKP2aJjWDjv2vjhwwgbAGCisGAQQBgjcCAQwxgaEw
// SIG // gZ6ggYOAgYAAVABGAFMALgBVAEkALgBDAG8AbgB0AHIA
// SIG // bwBsAHMALgBEAGEAdABhAC4AbQBpAG4AXwBlAGEAYwA4
// SIG // AGMAOABiADUALQA5AGIAYgBlAC0ANAA0ADMAMgAtAGEA
// SIG // MgAwAGEALQA4ADUANABlADUANwAwADQAYgBhADQAOAAu
// SIG // AGoAc6EWgBRodHRwOi8vbWljcm9zb2Z0LmNvbTANBgkq
// SIG // hkiG9w0BAQEFAASCAQArmiS4yN7AQmZgtASQDiPpqKoV
// SIG // b11JU8+cYkazd6Phu9KXlENo9/PLiNpDOJYd1GCqEJ1d
// SIG // vbB+ic54BplroPF53T3HkCA76gxdSoc5lpE2Bq9R/SA9
// SIG // TNjGotrHHE2PryP4qlnocUPvoBhTgZ/LpIlMhkNcHaZa
// SIG // ItGMQtso9kNigkItxr9FDbWxWRGyWmMSoGgROmH3s8xv
// SIG // jssqQMHrWRVkfOwbuvqa3MhZvgvsD9TzeL6QGJZM/vS8
// SIG // QImFnpPiLgZasJkawk415exiAvDJke+fHhnHDNwMFq1Z
// SIG // Sm7VOIcAzMNXvY3cgfDUHN9ToqFg5zBFGehw8sSLt4Mf
// SIG // gnfxiPBjoYICKDCCAiQGCSqGSIb3DQEJBjGCAhUwggIR
// SIG // AgEBMIGOMHcxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpX
// SIG // YXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYD
// SIG // VQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xITAfBgNV
// SIG // BAMTGE1pY3Jvc29mdCBUaW1lLVN0YW1wIFBDQQITMwAA
// SIG // AHGzLoprgqofTgAAAAAAcTAJBgUrDgMCGgUAoF0wGAYJ
// SIG // KoZIhvcNAQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0B
// SIG // CQUxDxcNMTUwNjI5MDQzNDMwWjAjBgkqhkiG9w0BCQQx
// SIG // FgQUEGEH0jZQd7mxZTY4KxmNUUFLgwcwDQYJKoZIhvcN
// SIG // AQEFBQAEggEAm9f1yLpUy1oIx9bPrlIxic3wGefhHKlF
// SIG // nkrJm3aYIlyEzVAPrq8eLtyVUttlVrKcEk78uNfbX6WJ
// SIG // +l/P+tRgFnIaGId1gbEgqSMluBVn1pg8webG+rQnFKm4
// SIG // gsfCckklPuSYMx9BtPMlC3a0c9AK2to9Q3VFt2b7XTdj
// SIG // mBQU3lEV10w0TYit78BAar5ZZGV/Zzu7EhVbbwRB0fWx
// SIG // J2RgnMWNO4t0tnrDIbD7qtKdA1e1/qxRdRzhXFhh9rAY
// SIG // hoFWmRMRawR+pPhjo6XAiml4NLwu+yUQpnj3RFgJC60m
// SIG // Yk3/R44+fKPWKXx+VVGR8LHgXVegaeRkIiBUYwXk/1qXMQ==
// SIG // End signature block
